<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Contrat extends Model 
{

    protected $table = 'contrats';
    public $timestamps = true;

    public function client()
    {
        return $this->belongsTo('App\Client', 'id_client');
    }

    public function lignesContrat()
    {
        return $this->hasMany('App\LigneContrat');
    }

    public function rdv()
    {
        return $this->hasMany('App\RDVTechnicien');
    }

    public function rdvCommercial()
    {
        return $this->belongsTo('App\RDVCommercial');
    }

}