<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Produit extends Model 
{

    protected $table = 'produits';
    public $timestamps = true;

    public function famille()
    {
        return $this->belongsTo('App\Famille', 'id_famille');
    }

    public function lignesContrat()
    {
        return $this->belongsToMany('App\LigneContrat');
    }

    public function lignesRdvTechniciens()
    {
        return $this->belongsToMany('App\LigneRdvTechnicien');
    }

    public function produitsActifsClient()
    {
        return $this->belongsToMany('App\ProduitActifClient');
    }

    public function videos()
    {
        return $this->hasMany('App\Video');
    }

    public function photos()
    {
        return $this->hasMany('Photo');
    }

}