<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRdvCommerciauxTable extends Migration {

	public function up()
	{
		Schema::create('rdvCommerciaux', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetime('dateRdv');
			$table->string('nomPossibleClient', 50);
			$table->string('prenomPossibleClient', 50);
			$table->string('telephonePossibleClient', 20);
			$table->string('emailPossibleClient', 100)->nullable();
			$table->string('adressePossibleClient', 300);
			$table->boolean('annule')->nullable();
			$table->integer('id_employe')->unsigned();
			$table->integer('id_contrat')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rdvCommerciaux');
	}
}