<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRdvTechniciensTable extends Migration {

	public function up()
	{
		Schema::create('rdvTechniciens', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetime('dateRdv');
			$table->enum('typeIntervention', array('installation', 'reparation', 'maintenance'));
			$table->text('description');
			$table->boolean('valide')->nullable();
			$table->boolean('annule')->nullable();
			$table->integer('id_employe')->unsigned();
			$table->integer('id_retour')->unsigned()->nullable();
			$table->integer('id_contrat')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('rdvTechniciens');
	}
}