<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->foreign('id_famille')->references('id')->on('familles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('id_departement')->references('id')->on('departementsFrancaises')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_role')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->foreign('id_client')->references('id')->on('clients')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->foreign('id_employe')->references('id')->on('employes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rdvTechniciens', function(Blueprint $table) {
			$table->foreign('id_employe')->references('id')->on('employes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rdvTechniciens', function(Blueprint $table) {
			$table->foreign('id_retour')->references('id')->on('retoursIntervention')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rdvTechniciens', function(Blueprint $table) {
			$table->foreign('id_contrat')->references('id')->on('contrats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('id_employe')->references('id')->on('employes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('id_produit')->references('id')->on('produits')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rdvCommerciaux', function(Blueprint $table) {
			$table->foreign('id_employe')->references('id')->on('employes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rdvCommerciaux', function(Blueprint $table) {
			$table->foreign('id_contrat')->references('id')->on('contrats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employes', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employes', function(Blueprint $table) {
			$table->foreign('id_departement')->references('id')->on('departementsFrancaises')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lignesContrat', function(Blueprint $table) {
			$table->foreign('id_contrat')->references('id')->on('contrats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lignesContrat', function(Blueprint $table) {
			$table->foreign('id_produit')->references('id')->on('produits')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lignesRdvTechnicien', function(Blueprint $table) {
			$table->foreign('id_RdvTechnicien')->references('id')->on('rdvTechniciens')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lignesRdvTechnicien', function(Blueprint $table) {
			$table->foreign('id_produit')->references('id')->on('produits')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('produitsActifsClient', function(Blueprint $table) {
			$table->foreign('id_client')->references('id')->on('clients')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('produitsActifsClient', function(Blueprint $table) {
			$table->foreign('id_produit')->references('id')->on('produits')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('CA', function(Blueprint $table) {
			$table->foreign('id_employe')->references('id')->on('employes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->foreign('id_produit')->references('id')->on('produits')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->dropForeign('produits_id_famille_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_id_user_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_id_departement_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_role_foreign');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->dropForeign('contrats_id_client_foreign');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->dropForeign('contrats_id_employe_foreign');
		});
		Schema::table('rdvTechniciens', function(Blueprint $table) {
			$table->dropForeign('rdvTechniciens_id_employe_foreign');
		});
		Schema::table('rdvTechniciens', function(Blueprint $table) {
			$table->dropForeign('rdvTechniciens_id_retour_foreign');
		});
		Schema::table('rdvTechniciens', function(Blueprint $table) {
			$table->dropForeign('rdvTechniciens_id_contrat_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_id_user_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_id_employe_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_id_produit_foreign');
		});
		Schema::table('rdvCommerciaux', function(Blueprint $table) {
			$table->dropForeign('rdvCommerciaux_id_employe_foreign');
		});
		Schema::table('rdvCommerciaux', function(Blueprint $table) {
			$table->dropForeign('rdvCommerciaux_id_contrat_foreign');
		});
		Schema::table('employes', function(Blueprint $table) {
			$table->dropForeign('employes_id_user_foreign');
		});
		Schema::table('employes', function(Blueprint $table) {
			$table->dropForeign('employes_id_departement_foreign');
		});
		Schema::table('lignesContrat', function(Blueprint $table) {
			$table->dropForeign('lignesContrat_id_contrat_foreign');
		});
		Schema::table('lignesContrat', function(Blueprint $table) {
			$table->dropForeign('lignesContrat_id_produit_foreign');
		});
		Schema::table('lignesRdvTechnicien', function(Blueprint $table) {
			$table->dropForeign('lignesRdvTechnicien_id_RdvTechnicien_foreign');
		});
		Schema::table('lignesRdvTechnicien', function(Blueprint $table) {
			$table->dropForeign('lignesRdvTechnicien_id_produit_foreign');
		});
		Schema::table('produitsActifsClient', function(Blueprint $table) {
			$table->dropForeign('produitsActifsClient_id_client_foreign');
		});
		Schema::table('produitsActifsClient', function(Blueprint $table) {
			$table->dropForeign('produitsActifsClient_id_produit_foreign');
		});
		Schema::table('CA', function(Blueprint $table) {
			$table->dropForeign('CA_id_employe_foreign');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->dropForeign('photos_id_produit_foreign');
		});
	}
}