<?php

namespace App;

class Employe extends Eloquent {

	protected $table = 'employes';
	public $timestamps = true;

	public function departements()
	{
		return $this->belongsTo('App\DepartementFrancais', 'id_departement');
	}

	public function rdvTechniciens()
	{
		return $this->hasMany('App\RDVTechnicien');
	}

	public function rdvCommerciaux()
	{
		return $this->hasMany('App\RDVCommercial');
	}

	public function users()
	{
		return $this->hasOne('App\User', 'id_user');
	}

	public function videos()
	{
		return $this->hasMany('App\Video');
	}

	public function news()
	{
		return $this->hasMany('App\News');
	}

	public function ca()
	{
		return $this->hasMany('App\CA');
	}

}