<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nom', 100);
			$table->string('prenom', 100);
			$table->string('telephone', 20);
			$table->string('adresse', 200);
			$table->string('ville', 100);
			$table->string('cp', 10);
			$table->string('email', 100);
			$table->boolean('annule')->nullable();
			$table->text('carateristiquesInstallation')->nullable();
			$table->integer('id_user')->unsigned();
			$table->integer('id_departement')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}