<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Messages extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;

    public function sender()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function files()
    {
        return $this->hasMany('Files', 'message_files', 'message_id', 'file_id')->withPivot('full_name', 'created_at');
    }

}