<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('Company', function(Blueprint $table) {
			$table->string('id', 250);
			$table->string('name', 250);
			$table->string('organization_type', 250);
			$table->text('description');
			$table->string('industry', 250);
			$table->datetime('founded_year');
			$table->string('employee_number', 50);
			$table->string('address');
			$table->string('state');
			$table->string('city', 100);
			$table->string('zip_code');
			$table->string('phone');
			$table->timestamps();
			$table->softDeletes();
			$table->text('service');
			$table->string('website', 250);
			$table->string('email', 100);
			$table->integer('category_id');
			$table->string('cover', 200);
			$table->string('status', 50);
			$table->string('country', 100);
		});
	}

	public function down()
	{
		Schema::drop('Company');
	}
}