<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chat extends Model 
{

    protected $table = 'chats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function messages()
    {
        return $this->hasMany('Message');
    }

    public function user1()
    {
        return $this->belongsTo('User');
    }

    public function user2()
    {
        return $this->belongsTo('User');
    }

    public function advert()
    {
        return $this->belongsTo('Advert');
    }

}