<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackageUserTable extends Migration {

	public function up()
	{
		Schema::create('package_user', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('package_id')->unsigned();
			$table->bigInteger('advert_id')->unsigned();
			$table->integer('duration');
			$table->decimal('price');
			$table->timestamp('expire_at');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('package_user');
	}
}