<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Content extends Model 
{

    protected $table = 'contents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');

    public function tags()
    {
        return $this->morphToMany('Tag', 'contentable');
    }

    public function posts()
    {
        return $this->morphToMany('Category', 'contentable');
    }

    public function users()
    {
        return $this->morphedByMany('User', 'contentable');
    }

    public function imagenes()
    {
        return $this->morphedByMany('Imagenes', 'contentable');
    }

    public function eventos()
    {
        return $this->morphedByMany('Event', 'contentable');
    }

}