<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('Name');
			$table->string('email')->unique();
			$table->string('mobile_no', 11)->unique();
			$table->enum('user_type', array('system', 'restaurant', 'customer'));
			$table->bigInteger('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}