<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shop extends Model 
{

    protected $table = 'shops';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function shopServices()
    {
        return $this->hasMany('Service', 'shop_id', 'id');
    }

    public function shopAvailability()
    {
        return $this->hasOne('Availability', 'shop_id', 'id');
    }

    public function openChairs()
    {
        return $this->hasMany('OpenChair', 'shop_id', 'id');
    }

    public function shopReviews()
    {
        return $this->hasMany('Review', 'shop_id', 'id');
    }

    public function shopBookings()
    {
        return $this->hasMany('Appointment', 'shop_id', 'id');
    }

    public function shopProducts()
    {
        return $this->hasMany('Product', 'shop_id', 'id');
    }

    public function shopOrders()
    {
        return $this->hasMany('Order', 'shop_id', 'id');
    }

}