<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function indepProServices()
    {
        return $this->hasMany('Service', 'user_id', 'id');
    }

    public function indepProAvailability()
    {
        return $this->hasOne('Availability', 'user_id', 'id');
    }

    public function indepProReviews()
    {
        return $this->hasMany('Review', 'user_id', 'id');
    }

    public function indepProProducts()
    {
        return $this->hasMany('Product', 'user_id', 'id');
    }

    public function indepProOrders()
    {
        return $this->hasMany('Order', 'user_id', 'id');
    }

}