<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('professional_id')->unsigned();
			$table->bigInteger('shop_id')->unsigned();
			$table->bigInteger('owner_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->string('email', 191);
			$table->bigInteger('phone_number');
			$table->string('shipping_address', 191);
			$table->string('order_status', 191);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}