<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('role_id')->unsigned();
			$table->string('name', 191);
			$table->string('email', 191);
			$table->string('password', 191);
			$table->string('profile_image', 191)->nullable();
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}