<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOpenChairsTable extends Migration {

	public function up()
	{
		Schema::create('open_chairs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('owner_id')->unsigned();
			$table->bigInteger('shop_id')->unsigned();
			$table->bigInteger('available_chairs');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('open_chairs');
	}
}