<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('professional_id')->unsigned()->nullable();
			$table->bigInteger('shop_id')->unsigned()->nullable();
			$table->string('name', 191);
			$table->time('approximate_time');
			$table->bigInteger('charges');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}