<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBiayaTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('biaya_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('id_transactions')->unsigned();
			$table->bigInteger('id_coa_with_org')->unsigned();
			$table->bigInteger('id_coa_with_org_bayar_dari')->unsigned();
			$table->string('description', 500)->nullable();
			$table->integer('total_qty')->nullable()->default('1');
			$table->bigInteger('price_per_qty')->nullable()->default('0');
			$table->bigInteger('price_total')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('biaya_transactions');
	}
}