<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('programs_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('id_program_with_org')->unsigned();
			$table->bigInteger('id_transactions')->unsigned();
			$table->string('description', 500)->nullable();
			$table->bigInteger('price_per_qty')->nullable()->default('0');
			$table->integer('total_qty')->nullable()->default('1');
			$table->bigInteger('price_total')->nullable()->default('0');
			$table->bigInteger('id_coa_with_org_choose')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('programs_transactions');
	}
}