<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('item_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('id_trs_with_org')->unsigned();
			$table->bigInteger('id_coa_with_org')->unsigned();
			$table->bigInteger('id_org')->unsigned();
			$table->bigInteger('nominal_debit')->default('0');
			$table->bigInteger('nominal_credit')->default('0');
			$table->integer('is_debit_credit');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('item_transactions');
	}
}