<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class NovelComment extends Model 
{

    protected $table = 'gooddreamer_novel_comment';
    public $timestamps = false;
    protected $fillable = array('id', 'user_id', 'comment_rating', 'comment_content', 'active', 'created_at', 'updated_at', 'novel_id', 'deleted_at');
    protected $visible = array('id', 'user_id', 'comment_rating', 'comment_content', 'active', 'created_at', 'updated_at', 'novel_id', 'deleted_at');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function novel()
    {
        return $this->belongsTo('Novel');
    }

}