<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model 
{

    protected $table = 'gooddreamer_transaction';
    public $timestamps = false;
    protected $fillable = array('id', 'user_id', 'package_id', 'payment_id', 'transaction_status', 'transaction_coin_value', 'created_at', 'updated_at');
    protected $visible = array('id', 'user_id', 'package_id', 'payment_id', 'transaction_status', 'transaction_coin_value', 'created_at', 'updated_at');

    public function package()
    {
        return $this->belongsTo('Package');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function walletItem()
    {
        return $this->morphOne('WalletItem', 'reffable');
    }

    public function payment()
    {
        return $this->belongsTo('Payment', 'payment_id');
    }

}