<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerContentTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_content', function(Blueprint $table) {
			$table->integer('id', true);
			$table->string('uuid');
			$table->string('content_name', 255);
			$table->smallInteger('content_sort');
			$table->string('content_icon_path', 255)->nullable();
			$table->string('content_icon_filename', 255)->nullable();
			$table->string('content_slug', 255)->primary();
			$table->smallInteger('type');
			$table->tinyInteger('active')->default('1');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_content');
	}
}