<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerNovelCommentTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_novel_comment', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->integer('user_id')->unsigned()->index();
			$table->integer('comment_rating');
			$table->string('comment_content', 255);
			$table->tinyInteger('active')->default('1');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->integer('novel_id')->unsigned()->index();
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_novel_comment');
	}
}