<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerBonusCoinTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_bonus_coin', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('receiver_id')->unsigned();
			$table->integer('sender_id')->unsigned();
			$table->integer('reward_item_id')->unsigned()->nullable();
			$table->enum('bonus_type', array('compliment', 'reward'));
			$table->tinyInteger('transaction_status')->default('2');
			$table->integer('transaction_coin_value');
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_bonus_coin');
	}
}