<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerRewardTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_reward', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('novel_id')->unsigned()->nullable();
			$table->enum('reward_slug', array('novel', 'daily'));
			$table->date('reward_start_date')->nullable();
			$table->date('reward_end_date')->nullable();
			$table->tinyInteger('active')->default('0');
			$table->datetime('created_at');
			$table->datetime('updated_at')->nullable();
			$table->datetime('deleted_at')->nullable();
			$table->datetime('published_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_reward');
	}
}