<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerUserWalletItemTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_user_wallet_item', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('wallet_id')->unsigned();
			$table->integer('reffable_id')->unsigned();
			$table->string('reffable_type', 255);
			$table->string('item_name');
			$table->enum('item_type', array('coin', 'novel', 'topup'));
			$table->enum('transaction_item', array('incoming', 'outgoing'));
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_user_wallet_item');
	}
}