<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class RewardItem extends Model 
{

    protected $table = 'gooddreamer_reward_item';
    public $timestamps = false;
    protected $fillable = array('id', 'reward_id', 'chapter_id', 'day_enum', 'coin_value', 'recurrring', 'active', 'created_at', 'updated_at', 'deleted_at', 'published_at');
    protected $visible = array('id', 'reward_id', 'chapter_id', 'day_enum', 'coin_value', 'recurrring', 'active', 'created_at', 'updated_at', 'deleted_at', 'published_at');

    public function reward()
    {
        return $this->belongsTo('Reward', 'reward_id');
    }

    public function chapter()
    {
        return $this->belongsTo('Chapter', 'chapter_id');
    }

    public function CoinTransaction()
    {
        return $this->hasMany('BonusCoin');
    }

    public function userReward()
    {
        return $this->hasOne('UserReward', 'reward_item_id');
    }

}