<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UserWallet extends Model 
{

    protected $table = 'gooddreamer_user_wallet';
    public $timestamps = false;
    protected $fillable = array('user_id', 'wallet_credit', 'created_at', 'updated_at');
    protected $visible = array('user_id', 'wallet_credit', 'created_at', 'updated_at');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function wallet_item()
    {
        return $this->hasMany('WalletItem', 'wallet_id');
    }

}