<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerNovelTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_novel', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->integer('language_id')->unsigned()->index();
			$table->integer('author_id')->unsigned()->index();
			$table->string('uuid', 255);
			$table->string('novel_title', 255);
			$table->text('novel_sinopsis');
			$table->string('novel_cover_path', 255);
			$table->string('nover_cover_filename');
			$table->float('novel_rating')->default('0');
			$table->integer('novel_price')->default('0');
			$table->tinyInteger('active')->default('1');
			$table->tinyInteger('status')->default('0');
			$table->tinyInteger('bundle')->default('0');
			$table->smallInteger('free_chapter')->default('5');
			$table->integer('published_by')->unsigned()->nullable();
			$table->datetime('published_at');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_novel');
	}
}