<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerPromoTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_promo', function(Blueprint $table) {
			$table->integer('id', true);
			$table->text('promo_content');
			$table->string('promo_path')->nullable();
			$table->string('promo_filename')->nullable();
			$table->date('promo_start_date')->nullable();
			$table->date('promo_end_date')->nullable();
			$table->string('promo_url', 255)->nullable();
			$table->enum('directive_type', array('in-app', 'external'))->nullable();
			$table->tinyInteger('active')->default('1');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_promo');
	}
}