<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerUserNovelProgressionTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('user_id')->unsigned();
			$table->integer('uc_id')->unsigned()->nullable();
			$table->integer('novel_id')->unsigned()->nullable();
			$table->integer('curr_chapter_id')->unsigned();
			$table->float('curr_progression')->default('0');
			$table->integer('total_chapter_read')->default('0');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_user_novel_progression');
	}
}