<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('gooddreamer_author', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('gooddreamer_admin')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('data_language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('gooddreamer_author')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel', function(Blueprint $table) {
			$table->foreign('published_by')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_novel_category', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_novel_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('data_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel_chapter', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel_comment', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel_comment', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_wallet', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_content_item', function(Blueprint $table) {
			$table->foreign('content_id')->references('id')->on('gooddreamer_content')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_content_item', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_collection', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_collection', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_log', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('gooddreamer_package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('gooddreamer_payment_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->foreign('referral_user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_notification_send_list', function(Blueprint $table) {
			$table->foreign('ns_id')->references('id')->on('gooddreamer_notification_scheduler')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_wallet_item', function(Blueprint $table) {
			$table->foreign('wallet_id')->references('id')->on('gooddreamer_user_wallet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel_transaction', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_novel_transaction', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_bonus_coin', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_bonus_coin', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_bonus_coin', function(Blueprint $table) {
			$table->foreign('reward_item_id')->references('id')->on('gooddreamer_reward_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_reward', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_reward_item', function(Blueprint $table) {
			$table->foreign('reward_id')->references('id')->on('gooddreamer_reward')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_reward_item', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('gooddreamer_reward_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->foreign('uc_id')->references('id')->on('gooddreamer_user_collection')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->foreign('curr_chapter_id')->references('id')->on('gooddreamer_novel_chapter')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_chapter_progression', function(Blueprint $table) {
			$table->foreign('novel_progression_id')->references('id')->on('gooddreamer_user_novel_progression')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_chapter_progression', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('gooddreamer_novel_chapter')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_reward', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_reward', function(Blueprint $table) {
			$table->foreign('reward_item_id')->references('id')->on('gooddreamer_reward_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_freebies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_freebies', function(Blueprint $table) {
			$table->foreign('origin_novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_freebies', function(Blueprint $table) {
			$table->foreign('novel_id')->references('id')->on('gooddreamer_novel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_user_referral_point', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_giveaway_period', function(Blueprint $table) {
			$table->foreign('winner_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_giveaway_leaderboard', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('gooddreamer_giveaway_period')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_giveaway_leaderboard', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_giveaway_notification', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('gooddreamer_user_data')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gooddreamer_giveaway_notification', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('gooddreamer_giveaway_period')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('gooddreamer_author', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_author_admin_id_foreign');
		});
		Schema::table('gooddreamer_novel', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_language_id_foreign');
		});
		Schema::table('gooddreamer_novel', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_author_id_foreign');
		});
		Schema::table('gooddreamer_novel', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_published_by_foreign');
		});
		Schema::table('pivot_novel_category', function(Blueprint $table) {
			$table->dropForeign('pivot_novel_category_novel_id_foreign');
		});
		Schema::table('pivot_novel_category', function(Blueprint $table) {
			$table->dropForeign('pivot_novel_category_category_id_foreign');
		});
		Schema::table('gooddreamer_novel_chapter', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_chapter_novel_id_foreign');
		});
		Schema::table('gooddreamer_novel_comment', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_comment_user_id_foreign');
		});
		Schema::table('gooddreamer_novel_comment', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_comment_novel_id_foreign');
		});
		Schema::table('gooddreamer_user_wallet', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_wallet_user_id_foreign');
		});
		Schema::table('gooddreamer_content_item', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_content_item_content_id_foreign');
		});
		Schema::table('gooddreamer_content_item', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_content_item_novel_id_foreign');
		});
		Schema::table('gooddreamer_user_collection', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_collection_user_id_foreign');
		});
		Schema::table('gooddreamer_user_collection', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_collection_novel_id_foreign');
		});
		Schema::table('admin_log', function(Blueprint $table) {
			$table->dropForeign('admin_log_admin_id_foreign');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_transaction_user_id_foreign');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_transaction_package_id_foreign');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_transaction_payment_id_foreign');
		});
		Schema::table('gooddreamer_transaction', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_transaction_referral_user_id_foreign');
		});
		Schema::table('gooddreamer_notification_send_list', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_notification_send_list_ns_id_foreign');
		});
		Schema::table('gooddreamer_user_wallet_item', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_wallet_item_wallet_id_foreign');
		});
		Schema::table('gooddreamer_novel_transaction', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_transaction_user_id_foreign');
		});
		Schema::table('gooddreamer_novel_transaction', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_novel_transaction_novel_id_foreign');
		});
		Schema::table('gooddreamer_bonus_coin', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_bonus_coin_receiver_id_foreign');
		});
		Schema::table('gooddreamer_bonus_coin', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_bonus_coin_sender_id_foreign');
		});
		Schema::table('gooddreamer_bonus_coin', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_bonus_coin_reward_item_id_foreign');
		});
		Schema::table('gooddreamer_reward', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_reward_novel_id_foreign');
		});
		Schema::table('gooddreamer_reward_item', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_reward_item_reward_id_foreign');
		});
		Schema::table('gooddreamer_reward_item', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_reward_item_chapter_id_foreign');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_novel_progression_user_id_foreign');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_novel_progression_uc_id_foreign');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_novel_progression_novel_id_foreign');
		});
		Schema::table('gooddreamer_user_novel_progression', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_novel_progression_curr_chapter_id_foreign');
		});
		Schema::table('gooddreamer_user_chapter_progression', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_chapter_progression_novel_progression_id_foreign');
		});
		Schema::table('gooddreamer_user_chapter_progression', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_chapter_progression_chapter_id_foreign');
		});
		Schema::table('gooddreamer_user_reward', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_reward_user_id_foreign');
		});
		Schema::table('gooddreamer_user_reward', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_reward_reward_item_id_foreign');
		});
		Schema::table('gooddreamer_user_freebies', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_freebies_user_id_foreign');
		});
		Schema::table('gooddreamer_user_freebies', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_freebies_origin_novel_id_foreign');
		});
		Schema::table('gooddreamer_user_freebies', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_freebies_novel_id_foreign');
		});
		Schema::table('gooddreamer_user_referral_point', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_user_referral_point_user_id_foreign');
		});
		Schema::table('gooddreamer_giveaway_period', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_giveaway_period_winner_id_foreign');
		});
		Schema::table('gooddreamer_giveaway_leaderboard', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_giveaway_leaderboard_period_id_foreign');
		});
		Schema::table('gooddreamer_giveaway_leaderboard', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_giveaway_leaderboard_user_id_foreign');
		});
		Schema::table('gooddreamer_giveaway_notification', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_giveaway_notification_user_id_foreign');
		});
		Schema::table('gooddreamer_giveaway_notification', function(Blueprint $table) {
			$table->dropForeign('gooddreamer_giveaway_notification_period_id_foreign');
		});
	}
}