<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerNovelChapterTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_novel_chapter', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('novel_id')->unsigned()->index();
			$table->string('chapter_title', 255);
			$table->longText('chapter_content');
			$table->tinyInteger('active')->default('1');
			$table->tinyInteger('status')->default('1');
			$table->datetime('created_at');
			$table->string('updated_at');
			$table->datetime('deleted_at');
			$table->datetime('published_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_novel_chapter');
	}
}