<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerRewardItemTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_reward_item', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('reward_id')->unsigned();
			$table->integer('chapter_id')->unsigned()->nullable();
			$table->integer('day_enum')->nullable();
			$table->integer('coin_value');
			$table->integer('recurrring')->nullable();
			$table->tinyInteger('active')->default('0');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at')->nullable();
			$table->datetime('published_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_reward_item');
	}
}