<?php

class ChapterProgression extends Eloquent {

	protected $table = 'gooddreamer_user_chapter_progression';
	public $timestamps = false;
	protected $fillable = array('id', 'novel_progression_id', 'chapter_id', 'progression', 'created_at', 'updated_at', 'deleted_at', 'is_completed');
	protected $visible = array('id', 'novel_progression_id', 'chapter_id', 'progression', 'created_at', 'updated_at', 'deleted_at', 'is_completed');

	public function novel_progression()
	{
		return $this->belongsTo('NovelProgression', 'novel_progression_id');
	}

	public function chapter()
	{
		return $this->belongsTo('Chapter', 'chapter_id');
	}

}