<?php

class Novel extends Eloquent {

	protected $table = 'gooddreamer_novel';
	public $timestamps = false;
	protected $fillable = array('id', 'language_id', 'author_id', 'uuid', 'novel_title', 'novel_sinopsis', 'novel_cover_path', 'nover_cover_filename', 'novel_rating', 'novel_price', 'active', 'status', 'bundle', 'free_chapter', 'published_by', 'published_at', 'created_at', 'updated_at', 'deleted_at');
	protected $visible = array('id', 'language_id', 'author_id', 'uuid', 'novel_title', 'novel_sinopsis', 'novel_cover_path', 'nover_cover_filename', 'novel_rating', 'novel_price', 'active', 'status', 'bundle', 'free_chapter', 'published_by', 'published_at', 'created_at', 'updated_at', 'deleted_at');

	public function author()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function category()
	{
		return $this->belongsToMany('Category', 'category_id')->using('NovelCategoryPivot);
	}

	public function chapter()
	{
		return $this->hasMany('Chapter');
	}

	public function comment()
	{
		return $this->hasMany('NovelComment');
	}

	public function collection()
	{
		return $this->hasManyThrough('Content', 'CollectionItem');
	}

	public function item()
	{
		return $this->hasMany('ContentItem');
	}

	public function userCollection()
	{
		return $this->hasMany('UserCollection');
	}

	public function novelTransaction()
	{
		return $this->hasMany('NovelTransaction');
	}

	public function reward()
	{
		return $this->hasMany('Reward');
	}

	public function novelProgression()
	{
		return $this->hasMany('NovelProgression', 'novel_id');
	}

	public function originFreebies()
	{
		return $this->hasMany('Freebies', 'origin_novel_id');
	}

	public function novel()
	{
		return $this->hasMany('Freebies', 'novel_id');
	}

}