<?php

class NovelProgression extends Eloquent {

	protected $table = 'gooddreamer_user_novel_progression';
	public $timestamps = false;
	protected $fillable = array('id', 'user_id', 'uc_id', 'novel_id', 'curr_progression', 'total_chapter_read', 'created_at', 'updated_at', 'deleted_at');
	protected $visible = array('id', 'user_id', 'uc_id', 'novel_id', 'curr_progression', 'total_chapter_read', 'created_at', 'updated_at', 'deleted_at');

	public function novel()
	{
		return $this->belongsTo('Novel', 'novel_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function userCollection()
	{
		return $this->belongsTo('UserCollection', 'uc_id');
	}

	public function chapterProgression()
	{
		return $this->hasMany('ChapterProgression', 'novel_progression_id');
	}

}