<?php

namespace Auth;

class User extends Eloquent {

	protected $table = 'gooddreamer_user_data';
	public $timestamps = false;
	protected $fillable = array('id', 'uuid', 'user_uri', 'email', 'country_code', 'phone', 'gender', 'username', 'dob', 'age', 'photo_profile_path', 'photo_profile_filename', 'is_guest', 'password', 'otp_pass', 'otp_valid_until', 'personal_bio', 'apns_token', 'fcm_token', 'google_token', 'device_token', 'email_verif_token', 'email_verif_expire', 'last_email_verif_date', 'active', 'referral_code', 'created_at', 'updated_at', 'deleted_at');
	protected $visible = array('id', 'uuid', 'user_uri', 'email', 'country_code', 'phone', 'gender', 'username', 'dob', 'age', 'photo_profile_path', 'photo_profile_filename', 'is_guest', 'otp_valid_until', 'personal_bio', 'apns_token', 'fcm_token', 'google_token', 'device_token', 'email_verif_token', 'email_verif_expire', 'last_email_verif_date', 'active', 'referral_code', 'updated_at', 'deleted_at');
	protected $hidden = array('password', 'otp_pass', 'created_at');

	public function comment()
	{
		return $this->hasMany('NovelComment');
	}

	public function wallet()
	{
		return $this->hasOne('UserWallet');
	}

	public function userCollection()
	{
		return $this->hasMany('UserCollection');
	}

	public function novel()
	{
		return $this->hasMany('Novel', 'author_id');
	}

	public function log()
	{
		return $this->hasMany('AdminLog', 'admin_id');
	}

	public function transaction()
	{
		return $this->hasMany('Transaction');
	}

	public function novelTransaction()
	{
		return $this->hasMany('NovelTransaction');
	}

	public function sender()
	{
		return $this->hasMany('BonusCoin', 'sender_id');
	}

	public function receiver()
	{
		return $this->hasMany('BonusCoin', 'receiver_id');
	}

	public function novelProgression()
	{
		return $this->hasMany('NovelProgression', 'user_id');
	}

	public function userReward()
	{
		return $this->hasMany('UserReward', 'user_id');
	}

	public function freebies()
	{
		return $this->hasMany('User', 'user_id');
	}

}