<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UserReward extends Model 
{

    protected $table = 'gooddreamer_user_reward';
    public $timestamps = false;
    protected $fillable = array('id', 'user_id', 'reward_item_id', 'created_at', 'updated_at', 'deleted_at');
    protected $visible = array('id', 'user_id', 'reward_item_id', 'created_at', 'updated_at', 'deleted_at');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function rewardItem()
    {
        return $this->belongsTo('RewardItem', 'reward_item_id');
    }

}