<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommandsTable extends Migration {

	public function up()
	{
		Schema::create('commands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('id_contract')->unsigned();
			$table->date('date_debut');
			$table->date('date_fin');
			$table->float('Total');
			$table->string('designation', 250);
			$table->string('fichiers', 250);
			$table->string('Referance', 250);
			$table->enum('status', array('inproccess', 'done'));
		});
	}

	public function down()
	{
		Schema::drop('commands');
	}
}