<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('kids', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('parents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lost_kids', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('parents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('kids', function(Blueprint $table) {
			$table->dropForeign('kids_parent_id_foreign');
		});
		Schema::table('lost_kids', function(Blueprint $table) {
			$table->dropForeign('lost_kids_parent_id_foreign');
		});
	}
}