<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKidsTable extends Migration {

	public function up()
	{
		Schema::create('kids', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('place')->nullable();
			$table->integer('age');
			$table->string('gender')->default('male');
			$table->string('address');
			$table->string('phone');
			$table->integer('parent_id')->unsigned();
			$table->string('image')->nullable();
			$table->string('birth_certificate')->nullable();
			$table->string('national_id')->nullable();
			$table->tinyInteger('is_lost')->default('0');
			$table->decimal('longitude', 10,8)->nullable();
			$table->decimal('latitude', 10,8)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('kids');
	}
}