<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTProductsTable extends Migration {

	public function up()
	{
		Schema::create('t_products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('number');
			$table->bigInteger('product_id')->unsigned();
			$table->bigInteger('stock_id')->unsigned();
			$table->bigInteger('travel_id')->unsigned();
			$table->integer('quantity');
			$table->string('unit', 191);
			$table->tinyInteger('type')->default('0');
			$table->decimal('price');
			$table->integer('barcode');
		});
	}

	public function down()
	{
		Schema::drop('t_products');
	}
}