<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBanksTable extends Migration {

	public function up()
	{
		Schema::create('banks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->date('created_at');
			$table->integer('code');
			$table->integer('ibon');
			$table->integer('account_num');
			$table->decimal('first_balance');
			$table->integer('Icon');
			$table->tinyInteger('type')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('banks');
	}
}