<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('country', 191);
			$table->string('governorate', 191);
			$table->string('region', 191);
			$table->string('address', 191);
			$table->string('company', 191);
			$table->integer('tax_num');
			$table->string('photo', 191);
			$table->tinyInteger('type')->default('0');
			$table->integer('mobile1');
			$table->integer('mobile2');
			$table->integer('phone');
			$table->integer('fax');
			$table->string('email');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}