<?php

namespace App\Models\Travel;

class Travel extends Eloquent {

	protected $table = 'travels';
	public $timestamps = true;
	protected $fillable = array('number', 'date', 'car_id', 'driver_id', 'place_do', 'Arrival', 'payload_w', 'unit', 'cost', 'pricing_type');

	public function customer()
	{
		return $this->hasOne('Customer');
	}

	public function car()
	{
		return $this->hasOne('Car');
	}

	public function driver()
	{
		return $this->hasOne('Driver');
	}

	public function t_products()
	{
		return $this->hasMany('T_product', 'travel_id');
	}

}