<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('address');
			$table->string('phone');
			$table->string('another_phone');
			$table->enum('type', array('Restaurant', 'Client', 'Online'));
			$table->enum('status', array('Bronze', 'Silver', 'Gold', 'Diamond'));
			$table->integer('order_quantity');
			$table->text('notes');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}